<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('menus', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('menus')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('menus', function(Blueprint $table) {
			$table->foreign('menu_section_id')->references('id')->on('menu_sections')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('activitytypes', function(Blueprint $table) {
			$table->foreign('sector_id')->references('id')->on('sectors')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('maincompany', function(Blueprint $table) {
			$table->foreign('app_client_id')->references('id')->on('app_clients')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('app_clients', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('roles', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('maincompany')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('role_permissions', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('role_permissions', function(Blueprint $table) {
			$table->foreign('company_menu_id')->references('id')->on('company_menu')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('company_menu', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('maincompany')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('company_menu', function(Blueprint $table) {
			$table->foreign('menu_id')->references('id')->on('menus')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_permissions', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('user_permissions', function(Blueprint $table) {
			$table->foreign('role_permission_id')->references('id')->on('role_permissions')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('activity_menu', function(Blueprint $table) {
			$table->foreign('activity_id')->references('id')->on('activitytypes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('activity_menu', function(Blueprint $table) {
			$table->foreign('menu_id')->references('id')->on('menus')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('menu_sectionables', function(Blueprint $table) {
			$table->foreign('menu_section_id')->references('id')->on('menu_sections')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('modules', function(Blueprint $table) {
			$table->foreign('activity_id')->references('id')->on('activitytypes')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('menu_module', function(Blueprint $table) {
			$table->foreign('module_id')->references('id')->on('modules')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('menu_module', function(Blueprint $table) {
			$table->foreign('menu_id')->references('id')->on('menus')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('menus', function(Blueprint $table) {
			$table->dropForeign('menus_parent_id_foreign');
		});
		Schema::table('menus', function(Blueprint $table) {
			$table->dropForeign('menus_menu_section_id_foreign');
		});
		Schema::table('activitytypes', function(Blueprint $table) {
			$table->dropForeign('activitytypes_sector_id_foreign');
		});
		Schema::table('maincompany', function(Blueprint $table) {
			$table->dropForeign('maincompany_app_client_id_foreign');
		});
		Schema::table('app_clients', function(Blueprint $table) {
			$table->dropForeign('app_clients_user_id_foreign');
		});
		Schema::table('roles', function(Blueprint $table) {
			$table->dropForeign('roles_company_id_foreign');
		});
		Schema::table('role_permissions', function(Blueprint $table) {
			$table->dropForeign('role_permissions_role_id_foreign');
		});
		Schema::table('role_permissions', function(Blueprint $table) {
			$table->dropForeign('role_permissions_company_menu_id_foreign');
		});
		Schema::table('company_menu', function(Blueprint $table) {
			$table->dropForeign('company_menu_company_id_foreign');
		});
		Schema::table('company_menu', function(Blueprint $table) {
			$table->dropForeign('company_menu_menu_id_foreign');
		});
		Schema::table('user_permissions', function(Blueprint $table) {
			$table->dropForeign('user_permissions_user_id_foreign');
		});
		Schema::table('user_permissions', function(Blueprint $table) {
			$table->dropForeign('user_permissions_role_permission_id_foreign');
		});
		Schema::table('activity_menu', function(Blueprint $table) {
			$table->dropForeign('activity_menu_activity_id_foreign');
		});
		Schema::table('activity_menu', function(Blueprint $table) {
			$table->dropForeign('activity_menu_menu_id_foreign');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->dropForeign('role_user_user_id_foreign');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->dropForeign('role_user_role_id_foreign');
		});
		Schema::table('menu_sectionables', function(Blueprint $table) {
			$table->dropForeign('menu_sectionables_menu_section_id_foreign');
		});
		Schema::table('modules', function(Blueprint $table) {
			$table->dropForeign('modules_activity_id_foreign');
		});
		Schema::table('menu_module', function(Blueprint $table) {
			$table->dropForeign('menu_module_module_id_foreign');
		});
		Schema::table('menu_module', function(Blueprint $table) {
			$table->dropForeign('menu_module_menu_id_foreign');
		});
	}
}