<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class MainCompany extends Eloquent {

	protected $table = 'maincompany';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('app_client_id');

	public function appClient()
	{
		return $this->belongsTo('App\Models\AppClient');
	}

	public function menus()
	{
		return $this->belongsToMany('App\Models\Menu');
	}

	public function roles()
	{
		return $this->hasMany('App\Models\Role');
	}

}