<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotificationsTable extends Migration {

	public function up()
	{
		Schema::create('notifications', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title');
			$table->text('content');
			$table->boolean('is_read')->default(0);
			$table->integer('merchant_id');
			$table->timestamps();
			$table->string('notificationable_type');
			$table->integer('notificationable_id');
		});
	}

	public function down()
	{
		Schema::drop('notifications');
	}
}