<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQrCodesTable extends Migration {

	public function up()
	{
		Schema::create('Qr_Codes', function(Blueprint $table) {
			$table->increments('id');
			$table->string('Unique_code', 255)->unique();
			$table->enum('Code_type', array('teacher', 'employee'));
			$table->char('Class_Name')->nullable();
			$table->boolean('Active_code')->default(true);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('Qr_Codes');
	}
}