<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStudentTable extends Migration {

	public function up()
	{
		Schema::create('Student', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->string('Student_number', 50);
			$table->enum('status', array('active', 'suspended', 'graduated', 'left'));
			$table->timestamps();
			$table->bigInteger('class_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('Student');
	}
}