<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMarkTable extends Migration {

	public function up()
	{
		Schema::create('Mark', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('student_id')->unsigned();
			$table->bigInteger('teacher_id')->unsigned();
			$table->enum('exam_type', array('quiz', 'midterm', 'final', 'homework', 'activity'));
			$table->integer('score')->unsigned()->default('0');
			$table->integer('max_score')->default('10');
			$table->date('date');
			$table->text('teacher_note')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('Mark');
	}
}