<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTextBookTable extends Migration {

	public function up()
	{
		Schema::create('Text_Book', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('subject_id')->unsigned();
			$table->bigInteger('education_level_id')->unsigned();
			$table->string('title', 50);
			$table->integer('total_quantity');
			$table->integer('sold_quantity')->default('0');
			$table->integer('price');
			$table->integer('available_quantity');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('Text_Book');
	}
}