<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Activitie extends Model 
{

    protected $table = 'Activitie';
    public $timestamps = true;
    protected $fillable = array('Title', 'class_id', 'education_level_id', 'Description', 'date', 'location', 'target_group', 'is_paid', 'cost', 'seats_limit', 'registration_deadline', 'is_open', 'gallery_urls', 'required_skills', 'auto_filter_participants');
    protected $visible = array('Title', 'class_id', 'education_level_id', 'Description', 'date', 'location', 'target_group', 'is_paid', 'cost', 'seats_limit', 'registration_deadline', 'is_open', 'gallery_urls', 'required_skills', 'auto_filter_participants');

    public function classes()
    {
        return $this->belongsTo('Class_room', 'class_id');
    }

    public function education_levels()
    {
        return $this->belongsTo('Education_level', 'education_level_id');
    }

    public function students()
    {
        return $this->hasMany('Activity_participants', 'student_id');
    }

    public function participants()
    {
        return $this->hasMany('Activity_participants', 'activity_id');
    }

}