<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Inventory extends Eloquent {

	protected $table = 'inventory';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('region_id', 'item_id', 'quantity', 'notes', 'site_id');

	public function site()
	{
		return $this->belongsTo('Site', 'site_id');
	}

	public function region()
	{
		return $this->belongsTo('Region', 'region_id');
	}

	public function item()
	{
		return $this->belongsTo('InventoryItem', 'item_id');
	}

}