<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePayrollEmployeeSalaryTrnTable extends Migration {

	public function up()
	{
		Schema::create('payroll_employee_salary_trn', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('type', 25)->nullable();
			$table->decimal('amount', 10,2)->nullable()->default('0');
			$table->integer('employee_id')->unsigned();
			$table->string('employee_code', 50)->nullable();
			$table->integer('income_code')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('payroll_employee_salary_trn');
	}
}