<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePayrollIncomeDeductTypeTable extends Migration {

	public function up()
	{
		Schema::create('payroll_income_deduct_type', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->char('code', 10)->unique();
			$table->string('description');
			$table->enum('field', array(''));
			$table->decimal('rate', 14,2);
			$table->enum('remuneration_type', array('NR', 'AR'));
			$table->integer('payslip_sort');
			$table->integer('epf');
			$table->integer('socso');
			$table->integer('tax');
			$table->enum('type', array('INCOME', 'DEDUCT'));
		});
	}

	public function down()
	{
		Schema::drop('payroll_income_deduct_type');
	}
}