<?php

namespace App/Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Task extends Eloquent {

	protected $table = 'tasks';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'title', 'description', 'status');

	public function comments()
	{
		return $this->hasMany('App/Models\Comment');
	}

}