<?php

namespace App/Model/CourseGoal;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CourseGoal extends Model 
{

    protected $table = 'course_goals';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('course_id', 'goal', 'status');

    public function courses()
    {
        return $this->belongsToMany('Course', 'course_id');
    }

}