<?php

namespace App/Model/Favourite;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Favourite extends Model 
{

    protected $table = 'favourites';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('student_id', 'favouritable_id', 'favouritable_type');

    public function student()
    {
        return $this->belongsTo('Student', 'student_id');
    }

}