<?php

namespace App/Model/Unit;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Unit extends Model 
{

    protected $table = 'units';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('level_id', 'status');

    public function level()
    {
        return $this->belongsTo('Level', 'level_id');
    }

}