<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('sections', function(Blueprint $table) {
			$table->foreign('page_id')->references('id')->on('pages')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('section_items', function(Blueprint $table) {
			$table->foreign('section_id')->references('id')->on('sections')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('course_features', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('course_goals', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('levels', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->foreign('level_id')->references('id')->on('levels')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('lessons', function(Blueprint $table) {
			$table->foreign('unit_id')->references('id')->on('units')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('course_users', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('course_users', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('students')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('flashcards', function(Blueprint $table) {
			$table->foreign('lesson_id')->references('id')->on('lessons')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('lesson_faqs', function(Blueprint $table) {
			$table->foreign('lesson_id')->references('id')->on('lessons')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('lesson_faqs', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('students')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('lesson_reviews', function(Blueprint $table) {
			$table->foreign('lesson_id')->references('id')->on('lessons')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('lesson_reviews', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('students')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('slider_images', function(Blueprint $table) {
			$table->foreign('page_id')->references('id')->on('pages')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('favourites', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('students')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('faqs', function(Blueprint $table) {
			$table->foreign('faq_category_id')->references('id')->on('faq_categories')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('student_lessons', function(Blueprint $table) {
			$table->foreign('lesson_id')->references('id')->on('lessons')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('student_lessons', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('students')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('quiz', function(Blueprint $table) {
			$table->foreign('lesson_id')->references('id')->on('lessons')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('quiz_question', function(Blueprint $table) {
			$table->foreign('quiz_id')->references('id')->on('quiz')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('quiz_answers', function(Blueprint $table) {
			$table->foreign('question_id')->references('id')->on('quiz_question')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('quiz_students', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('students')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('quiz_students', function(Blueprint $table) {
			$table->foreign('quiz_id')->references('id')->on('quiz')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('quiz_student_question', function(Blueprint $table) {
			$table->foreign('quiz_student_id')->references('id')->on('quiz_students')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('quiz_student_question', function(Blueprint $table) {
			$table->foreign('question_id')->references('id')->on('quiz_question')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('quiz_student_question', function(Blueprint $table) {
			$table->foreign('answer_id')->references('id')->on('quiz_answers')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('downloads', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('download_attachements', function(Blueprint $table) {
			$table->foreign('download_id')->references('id')->on('downloads')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('students')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->foreign('level_id')->references('id')->on('levels')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('sections', function(Blueprint $table) {
			$table->dropForeign('sections_page_id_foreign');
		});
		Schema::table('section_items', function(Blueprint $table) {
			$table->dropForeign('section_items_section_id_foreign');
		});
		Schema::table('course_features', function(Blueprint $table) {
			$table->dropForeign('course_features_course_id_foreign');
		});
		Schema::table('course_goals', function(Blueprint $table) {
			$table->dropForeign('course_goals_course_id_foreign');
		});
		Schema::table('levels', function(Blueprint $table) {
			$table->dropForeign('levels_course_id_foreign');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->dropForeign('units_level_id_foreign');
		});
		Schema::table('lessons', function(Blueprint $table) {
			$table->dropForeign('lessons_unit_id_foreign');
		});
		Schema::table('course_users', function(Blueprint $table) {
			$table->dropForeign('course_users_course_id_foreign');
		});
		Schema::table('course_users', function(Blueprint $table) {
			$table->dropForeign('course_users_student_id_foreign');
		});
		Schema::table('flashcards', function(Blueprint $table) {
			$table->dropForeign('flashcards_lesson_id_foreign');
		});
		Schema::table('lesson_faqs', function(Blueprint $table) {
			$table->dropForeign('lesson_faqs_lesson_id_foreign');
		});
		Schema::table('lesson_faqs', function(Blueprint $table) {
			$table->dropForeign('lesson_faqs_student_id_foreign');
		});
		Schema::table('lesson_reviews', function(Blueprint $table) {
			$table->dropForeign('lesson_reviews_lesson_id_foreign');
		});
		Schema::table('lesson_reviews', function(Blueprint $table) {
			$table->dropForeign('lesson_reviews_student_id_foreign');
		});
		Schema::table('slider_images', function(Blueprint $table) {
			$table->dropForeign('slider_images_page_id_foreign');
		});
		Schema::table('favourites', function(Blueprint $table) {
			$table->dropForeign('favourites_student_id_foreign');
		});
		Schema::table('faqs', function(Blueprint $table) {
			$table->dropForeign('faqs_faq_category_id_foreign');
		});
		Schema::table('student_lessons', function(Blueprint $table) {
			$table->dropForeign('student_lessons_lesson_id_foreign');
		});
		Schema::table('student_lessons', function(Blueprint $table) {
			$table->dropForeign('student_lessons_student_id_foreign');
		});
		Schema::table('quiz', function(Blueprint $table) {
			$table->dropForeign('quiz_lesson_id_foreign');
		});
		Schema::table('quiz_question', function(Blueprint $table) {
			$table->dropForeign('quiz_question_quiz_id_foreign');
		});
		Schema::table('quiz_answers', function(Blueprint $table) {
			$table->dropForeign('quiz_answers_question_id_foreign');
		});
		Schema::table('quiz_students', function(Blueprint $table) {
			$table->dropForeign('quiz_students_student_id_foreign');
		});
		Schema::table('quiz_students', function(Blueprint $table) {
			$table->dropForeign('quiz_students_quiz_id_foreign');
		});
		Schema::table('quiz_student_question', function(Blueprint $table) {
			$table->dropForeign('quiz_student_question_quiz_student_id_foreign');
		});
		Schema::table('quiz_student_question', function(Blueprint $table) {
			$table->dropForeign('quiz_student_question_question_id_foreign');
		});
		Schema::table('quiz_student_question', function(Blueprint $table) {
			$table->dropForeign('quiz_student_question_answer_id_foreign');
		});
		Schema::table('downloads', function(Blueprint $table) {
			$table->dropForeign('downloads_course_id_foreign');
		});
		Schema::table('download_attachements', function(Blueprint $table) {
			$table->dropForeign('download_attachements_download_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_student_id_foreign');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->dropForeign('order_items_order_id_foreign');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->dropForeign('order_items_course_id_foreign');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->dropForeign('order_items_level_id_foreign');
		});
	}
}