<?php

namespace App/Model/CourseFeature;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class CourseFeature extends Eloquent {

	protected $table = 'course_features';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('course_id', 'feature', 'status');

	public function courses()
	{
		return $this->belongsToMany('Course', 'course_id');
	}

}