<?php

namespace App/Model/Lesson;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Lesson extends Eloquent {

	protected $table = 'lessons';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('unit_id', 'number', 'title', 'description', 'Complete', 'notes');

	public function unit()
	{
		return $this->belongsTo('Unit', 'unit_id');
	}

}