<?php

namespace App/Model/Level;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Level extends Eloquent {

	protected $table = 'levels';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('course_id', 'number', 'type', 'price', 'discount', 'status', 'active');

	public function course()
	{
		return $this->belongsTo('Course', 'course_id');
	}

}