<?php

namespace App\Models\Order;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Order extends Eloquent {

	protected $table = 'orders';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('code', 'total_price', 'student_id', 'status');

	public function student()
	{
		return $this->belongsTo('Student', 'student_id');
	}

}