<?php

namespace App/Model/Quiz;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Quiz extends Eloquent {

	protected $table = 'quiz';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('degree', 'lesson_id', 'status');

	public function lesson()
	{
		return $this->belongsTo('Lesson', 'lesson_id');
	}

}