<?php

namespace App\Models\QuizAnswer;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class QuizAnswer extends Eloquent {

	protected $table = 'quiz_answers';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('question_id', 'answer', 'correct');

	public function quiz()
	{
		return $this->belongsTo('Quiz', 'quiz_id');
	}

}