<?php

namespace App\Models\QuizQuestion;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class QuizQuestion extends Eloquent {

	protected $table = 'quiz_question';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('quiz_id', 'question', 'status');

	public function quiz()
	{
		return $this->belongsTo('Quiz', 'quiz_id');
	}

}