<?php

namespace App/Model/Section;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Section extends Eloquent {

	protected $table = 'sections';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('page_id');

	public function sectionItems()
	{
		return $this->hasMany('SectionItem', 'section_id');
	}

}