<?php

namespace App/Model/SliderImage;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class SliderImage extends Eloquent {

	protected $table = 'slider_images';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('image', 'page_id', 'status');

	public function page()
	{
		return $this->belongsTo('Page', 'page_id');
	}

}