<?php

namespace App/Model/Unit;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Unit extends Eloquent {

	protected $table = 'units';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('level_id', 'status');

	public function level()
	{
		return $this->belongsTo('Level', 'level_id');
	}

}