<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuizQuestionTable extends Migration {

	public function up()
	{
		Schema::create('quiz_question', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('quiz_id')->unsigned();
			$table->text('question');
			$table->integer('status')->default('0');
			$table->enum('type', array('lesson', 'placementtest'));
		});
	}

	public function down()
	{
		Schema::drop('quiz_question');
	}
}