<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->string('email');
			$table->string('password');
			$table->integer('city_id')->unsigned();
			$table->string('location');
			$table->enum('type', array('1', '2'));
			$table->integer('parent_id')->unsigned();
			$table->string('phone')->nullable();
			$table->string('facebook_url')->nullable();
			$table->string('x_url');
			$table->string('insta_url');
			$table->string('youtube_url')->nullable();
			$table->string('image')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}