<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInstitutionsTable extends Migration {

	public function up()
	{
		Schema::create('institutions', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->bigInteger('institution_category_id')->unsigned();
			$table->bigInteger('responsible_id')->unsigned();
			$table->string('name', 128);
			$table->string('description', 1024);
			$table->string('street', 128);
			$table->string('city', 128);
			$table->string('zip', 8);
			$table->string('phone', 16);
			$table->string('logo', 256);
			$table->string('photo', 256);
			$table->string('web', 128);
			$table->timestamps();
			$table->softDeletes();
			$table->float('lat')->nullable();
			$table->float('lng')->nullable();
			$table->string('ico', 8)->unique();
			$table->boolean('active')->default(false);
			$table->string('phone_country', 2)->default('CZ');
			$table->string('email')->index();
		});
	}

	public function down()
	{
		Schema::drop('institutions');
	}
}