<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Employee', function(Blueprint $table) {
			$table->foreign('dep')->references('id')->on('Department')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Request', function(Blueprint $table) {
			$table->foreign('customer')->references('id')->on('Customer')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Request', function(Blueprint $table) {
			$table->foreign('department')->references('id')->on('Department')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Department', function(Blueprint $table) {
			$table->foreign('manager')->references('id')->on('Admin')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Post', function(Blueprint $table) {
			$table->foreign('auther_id')->references('id')->on('Admin')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('Employee', function(Blueprint $table) {
			$table->dropForeign('Employee_dep_foreign');
		});
		Schema::table('Request', function(Blueprint $table) {
			$table->dropForeign('Request_customer_foreign');
		});
		Schema::table('Request', function(Blueprint $table) {
			$table->dropForeign('Request_department_foreign');
		});
		Schema::table('Department', function(Blueprint $table) {
			$table->dropForeign('Department_manager_foreign');
		});
		Schema::table('Post', function(Blueprint $table) {
			$table->dropForeign('Post_auther_id_foreign');
		});
	}
}