<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('assignments', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('solutions', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('solutions', function(Blueprint $table) {
			$table->foreign('assignment_id')->references('id')->on('assignments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('assignments', function(Blueprint $table) {
			$table->dropForeign('assignments_created_by_foreign');
		});
		Schema::table('solutions', function(Blueprint $table) {
			$table->dropForeign('solutions_user_id_foreign');
		});
		Schema::table('solutions', function(Blueprint $table) {
			$table->dropForeign('solutions_assignment_id_foreign');
		});
	}
}