<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('username');
			$table->string('name');
			$table->string('email');
			$table->string('password');
			$table->timestamps();
			$table->softDeletes();
			$table->boolean('is_teacher')->default(false);
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}