<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('con_expert_categories', function(Blueprint $table) {
			$table->foreign('expertUserID')->references('id')->on('con_experts')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('con_expert_categories', function(Blueprint $table) {
			$table->foreign('categoryID')->references('id')->on('con_categories')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('con_package_service', function(Blueprint $table) {
			$table->foreign('package_id')->references('id')->on('con_packages')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('con_package_service', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('con_services')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('con_expert_categories', function(Blueprint $table) {
			$table->dropForeign('con_expert_categories_expertUserID_foreign');
		});
		Schema::table('con_expert_categories', function(Blueprint $table) {
			$table->dropForeign('con_expert_categories_categoryID_foreign');
		});
		Schema::table('con_package_service', function(Blueprint $table) {
			$table->dropForeign('con_package_service_package_id_foreign');
		});
		Schema::table('con_package_service', function(Blueprint $table) {
			$table->dropForeign('con_package_service_service_id_foreign');
		});
	}
}