<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDeliveryOrderTable extends Migration {

	public function up()
	{
		Schema::create('delivery_order', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('order_id');
			$table->integer('delivery_id');
			$table->float('price');
			$table->enum('status', array('pending', 'accepted', 'rejected', 'canceled'));
			$table->float('deliver_expected_time');
			$table->float('minuets_far_target_location');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('delivery_order');
	}
}