<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Event extends Eloquent {

	protected $table = 'event';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'description');
	protected $visible = array('name', 'description');

	public function has_venue()
	{
		return $this->belongsTo('Venue');
	}

	public function has_ticketclass()
	{
		return $this->hasMany('TicketClass');
	}

}