<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Salon extends Eloquent {

	protected $table = 'salons';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function services()
	{
		return $this->hasMany('\Service', 'salon_id');
	}

	public function packages()
	{
		return $this->hasMany('\Package', 'salon_id');
	}

	public function orders()
	{
		return $this->hasMany('\Order', 'salon_id');
	}

	public function users()
	{
		return $this->hasMany('User');
	}

}