<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDestinationsTable extends Migration {

	public function up()
	{
		Schema::create('destinations', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('campaign_id')->unsigned();
			$table->integer('airport_departure_id')->unsigned();
			$table->integer('airport_destination_id')->unsigned();
			$table->decimal('price', 10,2);
			$table->decimal('price_promotion', 10,2)->nullable();
			$table->string('cta', 250)->nullable();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('destinations');
	}
}