<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Aid extends Model 
{

    protected $table = 'aids';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $hidden = array('id', 'entry_id', 'user_id', 'timestamps');

    public function entry()
    {
        return $this->belongsTo('Entry');
    }

    public function user()
    {
        return $this->belongsTo('User');
    }

}