<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Entry extends Eloquent {

	protected $table = 'entries';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $hidden = array('user_id', 'campaign_id', 'destination_id', 'activated', 'timestamps');

	public function campaign()
	{
		return $this->belongsTo('Campaign');
	}

	public function destination()
	{
		return $this->belongsTo('Destination');
	}

	public function user()
	{
		return $this->belongsTo('User');
	}

	public function aids()
	{
		return $this->hasMany('Aid');
	}

}