<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlansTable extends Migration {

	public function up()
	{
		Schema::create('plans', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->double('price');
			$table->text('description');
			$table->integer('provider_id')->unsigned();
			$table->date('date');
			$table->time('time');
		});
	}

	public function down()
	{
		Schema::drop('plans');
	}
}