<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class LegalCase extends Model 
{

    protected $table = 'legal_cases';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function MLRInfo()
    {
        return $this->hasOne('LegalCaseMLRInfo');
    }

    public function client()
    {
        return $this->hasMany('LegalCaseClient');
    }

    public function agent()
    {
        return $this->hasOne('LegalCaseAgent');
    }

    public function participant()
    {
        return $this->hasMany('LegalCaseMLRParticipant');
    }

    public function financial()
    {
        return $this->hasOne('MLRFinancial');
    }

    public function compliance()
    {
        return $this->hasOne('MLRCompliance');
    }

    public function specialCondition()
    {
        return $this->hasMany('MLRSpecialCondition');
    }

}