<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLegalCaseMlrParticipantsTable extends Migration {

	public function up()
	{
		Schema::create('legal_case_mlr_participants', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('legal_case_id')->unsigned();
			$table->enum('type', array('seller', 'buyer', 'other'));
			$table->enum('role', array('agent', 'solicitor', 'customer', 'guarantor', 'notice-address'));
			$table->string('license_number')->nullable();
			$table->string('name');
			$table->string('email');
			$table->string('phone_number');
			$table->string('mobile_number');
			$table->string('fax');
			$table->string('address');
			$table->string('suburbs');
			$table->string('postal_code');
			$table->string('state');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('legal_case_mlr_participants');
	}
}