<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMlrFinancialTable extends Migration {

	public function up()
	{
		Schema::create('mlr_financial', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('legal_case_id')->unsigned();
			$table->string('name');
			$table->string('email');
			$table->string('business_phone_number');
			$table->string('phone_number');
			$table->string('fax');
			$table->string('address');
			$table->string('suburbs');
			$table->string('postal_code');
			$table->string('state');
			$table->datetime('verification_duedate');
			$table->string('verification_period');
			$table->decimal('minimum_net_profit', 15,2);
			$table->text('unencumbered_equipment');
			$table->text('leased_equipment');
			$table->text('rental_agreement');
			$table->datetime('nominated_stocktake_date');
			$table->decimal('maximum_stock_valuation', 15,2);
			$table->decimal('purchase_price', 15,2);
			$table->decimal('purchase_deposit', 15,2);
			$table->decimal('purchase_balance', 15,2);
			$table->decimal('apportionment_purchase_plants', 15,2);
			$table->decimal('apportionment_purchase_furnitures', 15,2);
			$table->decimal('apportionment_purchase_chattels', 15,2);
			$table->decimal('apportionment_purchase_fixtures', 15,2);
			$table->decimal('apportionment_purchase_goodwill', 15,2);
			$table->decimal('apportionment_purchase_restrictive_covenant', 15,2);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('mlr_financial');
	}
}