<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('legal_cases', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('legal_cases')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('legal_case_mlr_info', function(Blueprint $table) {
			$table->foreign('legal_case_id')->references('id')->on('legal_cases')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('legal_case_clients', function(Blueprint $table) {
			$table->foreign('legal_case_id')->references('id')->on('legal_cases')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('legal_case_agent', function(Blueprint $table) {
			$table->foreign('legal_case_id')->references('id')->on('legal_cases')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('legal_case_mlr_participants', function(Blueprint $table) {
			$table->foreign('legal_case_id')->references('id')->on('legal_cases')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('mlr_financial', function(Blueprint $table) {
			$table->foreign('legal_case_id')->references('id')->on('legal_cases')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('mlr_compliance', function(Blueprint $table) {
			$table->foreign('legal_case_id')->references('id')->on('legal_cases')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('mlr_special_condition', function(Blueprint $table) {
			$table->foreign('legal_case_id')->references('id')->on('legal_cases')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('mlr_compliance_employee', function(Blueprint $table) {
			$table->foreign('mlr_compliance_id')->references('id')->on('mlr_compliance')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('legal_cases', function(Blueprint $table) {
			$table->dropForeign('legal_cases_parent_id_foreign');
		});
		Schema::table('legal_case_mlr_info', function(Blueprint $table) {
			$table->dropForeign('legal_case_mlr_info_legal_case_id_foreign');
		});
		Schema::table('legal_case_clients', function(Blueprint $table) {
			$table->dropForeign('legal_case_clients_legal_case_id_foreign');
		});
		Schema::table('legal_case_agent', function(Blueprint $table) {
			$table->dropForeign('legal_case_agent_legal_case_id_foreign');
		});
		Schema::table('legal_case_mlr_participants', function(Blueprint $table) {
			$table->dropForeign('legal_case_mlr_participants_legal_case_id_foreign');
		});
		Schema::table('mlr_financial', function(Blueprint $table) {
			$table->dropForeign('mlr_financial_legal_case_id_foreign');
		});
		Schema::table('mlr_compliance', function(Blueprint $table) {
			$table->dropForeign('mlr_compliance_legal_case_id_foreign');
		});
		Schema::table('mlr_special_condition', function(Blueprint $table) {
			$table->dropForeign('mlr_special_condition_legal_case_id_foreign');
		});
		Schema::table('mlr_compliance_employee', function(Blueprint $table) {
			$table->dropForeign('mlr_compliance_employee_mlr_compliance_id_foreign');
		});
	}
}