<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProfileTable extends Migration {

	public function up()
	{
		Schema::create('profile', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->string('name');
			$table->string('logo')->nullable();
			$table->string('phone');
			$table->string('email');
			$table->string('website');
			$table->integer('tax');
			$table->integer('due_date');
			$table->integer('currency');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('profile');
	}
}