<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoicesTable extends Migration {

	public function up()
	{
		Schema::create('invoices', function(Blueprint $table) {
			$table->increments('id');
			$table->date('invoice_date');
			$table->longText('description')->nullable();
			$table->string('forwarded_to')->nullable();
			$table->integer('commercial_proposal_id')->unsigned();
			$table->integer('total')->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('invoices');
	}
}