<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsuariosTable extends Migration {

	public function up()
	{
		Schema::create('usuarios', function(Blueprint $table) {
			$table->increments('id_usuario');
			$table->string('email');
			$table->string('usuario');
			$table->string('password');
			$table->string('nombre');
			$table->string('apellido');
			$table->integer('dni');
			$table->date('fecha_nacimiento');
			$table->string('genero', 1);
			$table->integer('id_localidad');
			$table->smallInteger('cod_postal');
			$table->string('calle');
			$table->integer('altura');
			$table->string('piso', 4);
			$table->string('depto', 4);
			$table->smallInteger('cod_area_fijo');
			$table->integer('tel_fijo');
			$table->smallInteger('cod_area_movil');
			$table->integer('tel_movil');
			$table->integer('id_rol');
			$table->tinyInteger('activado');
			$table->timestamp('fecha_activacion');
			$table->timestamp('ultimo_logueo');
			$table->string('cod_reseteo_password');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('usuarios');
	}
}