<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCarsTable extends Migration {

	public function up()
	{
		Schema::create('cars', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('front_license')->nullable();
			$table->string('back_license')->nullable();
			$table->string('image');
			$table->string('type');
			$table->string('brand')->nullable();
			$table->string('model')->nullable();
			$table->string('color')->nullable();
			$table->integer('car_num')->nullable();
			$table->string('salaryPerKilo')->nullable();
			$table->integer('driver_id');
		});
	}

	public function down()
	{
		Schema::drop('cars');
	}
}