<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Payment extends Model 
{

    protected $table = 'payments';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('amount', 'user_id', 'order_id');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function service()
    {
        return $this->belongsTo('Service', 'service_id');
    }

}