<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Subscription extends Model 
{

    protected $table = 'subscriptions';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'service_id', 'start_date', 'end_date');

    public function user()
    {
        return $this->belongsTo('\User', 'user_id');
    }

    public function service_id()
    {
        return $this->belongsTo('\Service', 'service_id');
    }

}